/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.GLRenderDevice;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformBlock;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat2v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat3v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformInt;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformMatrix4f;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.features.FeatureFlags;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.mixin.texture.TextureAtlasAccessor;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.GlUniformMatrix3f;
import net.irisshaders.iris.pipeline.programs.SodiumPrograms;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.CommonUniforms;
import net.irisshaders.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_12134;
import net.minecraft.class_12137;
import net.minecraft.class_310;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL33C;

public class SodiumShader
implements ChunkShaderInterface {
    private static final int SUB_TEXEL_PRECISION_BITS = 5;
    private final GlUniformMatrix4f uniformModelViewMatrix;
    private final GlUniformMatrix4f uniformModelViewMatrixInv;
    private final GlUniformMatrix4f uniformProjectionMatrix;
    private final GlUniformMatrix4f uniformProjectionMatrixInv;
    private final GlUniformMatrix3f uniformNormalMatrix;
    private final GlUniformFloat3v uniformRegionOffset;
    private final GlUniformFloat2v uniformTexCoordShrink;
    private final ProgramImages images;
    private final ProgramSamplers samplers;
    private final ProgramUniforms uniforms;
    private final CustomUniforms customUniforms;
    private final BlendModeOverride blendModeOverride;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final float alphaTest;
    private final boolean containsTessellation;
    private final boolean anisotropySupported;
    private boolean isShadowPass;
    private final GlUniformFloat2v uniformTexelSize;
    private final GlUniformInt uniformCurrentTime;
    private final GlUniformBlock uniformChunkData;

    public SodiumShader(IrisRenderingPipeline pipeline, SodiumPrograms.Pass pass, ShaderBindingContext context, int handle, BlendModeOverride blendModeOverride, List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms, Supplier<ImmutableSet<Integer>> flipState, float alphaTest, boolean containsTessellation) {
        this.anisotropySupported = pipeline.hasFeature(FeatureFlags.TEXTURE_FILTERING);
        this.uniformModelViewMatrix = (GlUniformMatrix4f)context.bindUniformOptional("iris_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformModelViewMatrixInv = (GlUniformMatrix4f)context.bindUniformOptional("iris_ModelViewMatrixInverse", GlUniformMatrix4f::new);
        this.uniformNormalMatrix = (GlUniformMatrix3f)context.bindUniformOptional("iris_NormalMatrix", GlUniformMatrix3f::new);
        this.uniformProjectionMatrix = (GlUniformMatrix4f)context.bindUniformOptional("iris_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrixInv = (GlUniformMatrix4f)context.bindUniformOptional("iris_ProjectionMatrixInv", GlUniformMatrix4f::new);
        this.uniformRegionOffset = (GlUniformFloat3v)context.bindUniformOptional("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformTexCoordShrink = (GlUniformFloat2v)context.bindUniformOptional("u_TexCoordShrink", GlUniformFloat2v::new);
        this.uniformCurrentTime = (GlUniformInt)context.bindUniformOptional("iris_CurrentTime", GlUniformInt::new);
        this.uniformTexelSize = (GlUniformFloat2v)context.bindUniformOptional("iris_TexelSize", GlUniformFloat2v::new);
        this.uniformChunkData = context.bindUniformBlockOptional("iris_ChunkData", 0);
        this.alphaTest = alphaTest;
        this.containsTessellation = containsTessellation;
        this.isShadowPass = pass == SodiumPrograms.Pass.SHADOW || pass == SodiumPrograms.Pass.SHADOW_CUTOUT;
        this.uniforms = this.buildUniforms(pass, handle, customUniforms);
        this.customUniforms = customUniforms;
        this.samplers = this.buildSamplers(pipeline, pass, handle, this.isShadowPass, flipState);
        this.images = this.buildImages(pipeline, pass, handle, this.isShadowPass, flipState);
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
    }

    private ProgramUniforms buildUniforms(SodiumPrograms.Pass pass, int handle, CustomUniforms customUniforms) {
        ProgramUniforms.Builder builder = ProgramUniforms.builder(pass.name().toLowerCase(Locale.ROOT), handle);
        CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
        customUniforms.assignTo(builder);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(builder);
        customUniforms.mapholderToPass(builder, this);
        return builder.buildUniforms();
    }

    private ProgramSamplers buildSamplers(IrisRenderingPipeline pipeline, SodiumPrograms.Pass pass, int handle, boolean isShadowPass, Supplier<ImmutableSet<Integer>> flipState) {
        ProgramSamplers.Builder builder = ProgramSamplers.builder(handle, IrisSamplers.SODIUM_RESERVED_TEXTURE_UNITS);
        pipeline.addGbufferOrShadowSamplers(builder, ProgramImages.builder(handle), flipState, isShadowPass, true, true, false);
        return builder.build();
    }

    private ProgramImages buildImages(IrisRenderingPipeline pipeline, SodiumPrograms.Pass pass, int handle, boolean isShadowPass, Supplier<ImmutableSet<Integer>> flipState) {
        ProgramImages.Builder builder = ProgramImages.builder(handle);
        pipeline.addGbufferOrShadowSamplers(ProgramSamplers.builder(handle, IrisSamplers.SODIUM_RESERVED_TEXTURE_UNITS), builder, flipState, isShadowPass, true, true, false);
        return builder.build();
    }

    public void setRegionOffset(float x, float y, float z) {
        if (this.uniformRegionOffset != null) {
            this.uniformRegionOffset.set(x, y, z);
        }
    }

    public void setChunkData(GlBuffer data, int time) {
        if (this.uniformChunkData != null) {
            this.uniformChunkData.bindBuffer(data);
        }
        if (this.uniformCurrentTime != null) {
            this.uniformCurrentTime.set(Integer.valueOf(time));
        }
    }

    public void setModelViewMatrix(Matrix4fc matrix) {
        if (this.uniformModelViewMatrix != null) {
            this.uniformModelViewMatrix.set(matrix);
        }
        Matrix4f invertedMatrix = matrix.invert(new Matrix4f());
        if (this.uniformModelViewMatrixInv != null) {
            this.uniformModelViewMatrixInv.set((Matrix4fc)invertedMatrix);
        }
        if (this.uniformNormalMatrix != null) {
            Matrix3f normalMatrix = invertedMatrix.transpose3x3(new Matrix3f());
            this.uniformNormalMatrix.set((Matrix3fc)normalMatrix);
        }
    }

    public void setProjectionMatrix(Matrix4fc matrix) {
        if (this.uniformProjectionMatrix != null) {
            this.uniformProjectionMatrix.set(matrix);
        }
        if (this.uniformProjectionMatrixInv != null) {
            Matrix4f invertedMatrix = matrix.invert(new Matrix4f());
            this.uniformProjectionMatrixInv.set((Matrix4fc)invertedMatrix);
        }
    }

    public void setupState(TerrainRenderPass pass, FogParameters fogParameters, class_12137 gpuSampler) {
        DepthColorStorage.unlockDepthColor();
        this.applyBlendModes();
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline irp = (IrisRenderingPipeline)worldRenderingPipeline;
            irp.onSetAlbedoTex(pass.getAtlas());
        }
        this.updateUniforms();
        this.images.update();
        if (this.isShadowPass) {
            GlStateManager._disableCull();
        }
        class_1044 textureAtlas = class_310.method_1551().method_1531().method_4619(class_1059.field_5275);
        double subTexelPrecision = 1 << GLRenderDevice.INSTANCE.getSubTexelPrecisionBits();
        double subTexelOffset = 3.0517578125E-5;
        if (this.uniformTexCoordShrink != null) {
            this.uniformTexCoordShrink.set((float)(subTexelOffset - 1.0 / (double)((TextureAtlasAccessor)textureAtlas).callGetWidth() / subTexelPrecision), (float)(subTexelOffset - 1.0 / (double)((TextureAtlasAccessor)textureAtlas).callGetHeight() / subTexelPrecision));
        }
        if (this.uniformTexelSize != null) {
            this.uniformTexelSize.set((float)(1.0 / (double)textureAtlas.method_68004().getWidth(0)), (float)(1.0 / (double)textureAtlas.method_68004().getHeight(0)));
        }
        this.bindTextures(pass.getAtlas(), this.anisotropySupported ? (class_12134)gpuSampler : (class_12134)RenderSystem.getSamplerCache().method_75293(AddressMode.CLAMP_TO_EDGE, AddressMode.CLAMP_TO_EDGE, FilterMode.NEAREST, FilterMode.NEAREST, true));
        if (this.containsTessellation) {
            ImmediateState.usingTessellation = true;
        }
    }

    private void bindTextures(GpuTextureView atlas, class_12134 sampler) {
        IrisRenderSystem.bindTextureToUnit(3553, 0, atlas.texture().iris$getGlId());
        GlStateManager._activeTexture((int)33984);
        GlStateManager._texParameter((int)3553, (int)33084, (int)atlas.baseMipLevel());
        GlStateManager._texParameter((int)3553, (int)33085, (int)(atlas.baseMipLevel() + atlas.mipLevels() - 1));
        GL33C.glBindSampler((int)0, (int)sampler.method_75285());
        GpuTextureView lightmap = class_310.method_1551().field_1773.method_22974().method_71650();
        IrisRenderSystem.bindTextureToUnit(3553, 2, lightmap.texture().iris$getGlId());
        GlStateManager._activeTexture((int)33986);
    }

    private void applyBlendModes() {
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
    }

    private void updateUniforms() {
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        this.samplers.update();
        this.uniforms.update();
        this.customUniforms.push(this);
    }

    public void resetState() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        BlendModeOverride.restore();
        ImmediateState.usingTessellation = false;
    }
}

