/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.util.nbt.BaseNbtStringifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SimpleNbtStringifier
extends BaseNbtStringifier {
    protected StringBuilder stringBuilder;

    public SimpleNbtStringifier() {
        super(false, true, "");
    }

    public SimpleNbtStringifier(String baseColor) {
        super(true, true, baseColor);
    }

    public String getNbtString(class_2487 tag) {
        this.stringBuilder = new StringBuilder();
        if (this.colored) {
            this.stringBuilder.append(this.baseColor);
        }
        this.appendCompound("", tag);
        return this.stringBuilder.toString();
    }

    @Override
    protected void appendPrimitive(String tagName, class_2520 tag) {
        this.stringBuilder.append(this.getFormattedPrimitiveString(tag));
    }

    @Override
    protected void appendCompound(String tagName, class_2487 tag) {
        ArrayList keys = Lists.newArrayList((Iterable)tag.method_10541());
        Collections.sort(keys);
        boolean first = true;
        this.stringBuilder.append('{');
        for (String key : keys) {
            if (!first) {
                this.stringBuilder.append(',');
            }
            this.stringBuilder.append(this.getFormattedTagName(key));
            this.stringBuilder.append(':');
            this.appendTag(key, Objects.requireNonNull(tag.method_10580(key)));
            first = false;
        }
        this.stringBuilder.append('}');
    }

    @Override
    protected void appendList(String tagName, class_2499 list) {
        int size = list.size();
        this.stringBuilder.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.stringBuilder.append(',');
            }
            this.appendTag("", list.method_10534(i));
        }
        this.stringBuilder.append(']');
    }

    @Override
    protected void appendByteArray(String tagName, byte[] arr) {
        String valueColorStr = this.colored ? this.getPrimitiveColorCode(1) : null;
        String numberSuffixStr = this.useNumberSuffix ? this.getNumberSuffix(1) : null;
        int size = arr.length;
        this.stringBuilder.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.stringBuilder.append(',');
            }
            this.stringBuilder.append(this.getFormattedPrimitiveString(String.valueOf(arr[i]), false, valueColorStr, numberSuffixStr));
        }
        this.stringBuilder.append(']');
    }

    @Override
    protected void appendIntArray(String tagName, int[] arr) {
        String valueColorStr = this.colored ? this.getPrimitiveColorCode(3) : null;
        String numberSuffixStr = this.useNumberSuffix ? this.getNumberSuffix(3) : null;
        int size = arr.length;
        this.stringBuilder.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.stringBuilder.append(',');
            }
            this.stringBuilder.append(this.getFormattedPrimitiveString(String.valueOf(arr[i]), false, valueColorStr, numberSuffixStr));
        }
        this.stringBuilder.append(']');
    }

    @Override
    protected void appendLongArray(String tagName, long[] arr) {
        String valueColorStr = this.colored ? this.getPrimitiveColorCode(4) : null;
        String numberSuffixStr = this.useNumberSuffix ? this.getNumberSuffix(4) : null;
        int size = arr.length;
        this.stringBuilder.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.stringBuilder.append(',');
            }
            this.stringBuilder.append(this.getFormattedPrimitiveString(String.valueOf(arr[i]), false, valueColorStr, numberSuffixStr));
        }
        this.stringBuilder.append(']');
    }
}

