/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataOps;
import fi.dy.masa.malilib.util.data.tag.util.DataTypeUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4482;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8242;
import net.minecraft.class_8514;
import net.minecraft.class_8966;
import net.minecraft.class_9296;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DataBlockUtils {
    @Nullable
    public static class_2591<?> getBlockEntityType(@Nonnull CompoundData data) {
        if (data.contains("id", 8)) {
            return class_7923.field_41181.method_17966(class_2960.method_12829((String)data.getString("id"))).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_2561 getCustomName(@Nonnull CompoundData data, @Nonnull class_5455 registry, String key) {
        NbtView view = NbtView.getReader(data, registry);
        return class_2586.method_59894((class_11368)Objects.requireNonNull(view.getReader()), (String)key);
    }

    public static CompoundData setBlockEntityType(class_2591<?> type, @Nullable CompoundData dataIn) {
        CompoundData data = new CompoundData();
        class_2960 id = class_2591.method_11033(type);
        if (id != null) {
            return Objects.requireNonNullElse(dataIn, data).putString("id", id.toString());
        }
        return data;
    }

    public static Set<Integer> getDisabledSlots(@Nonnull CompoundData data) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (data.contains("disabled_slots", 11)) {
            int[] is;
            for (int j : is = data.getIntArray("disabled_slots")) {
                list.add(j);
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_6880<@NotNull class_1291>, class_6880<@NotNull class_1291>> getBeaconEffects(@Nonnull CompoundData data) {
        Set<@NotNull T> effects = class_2580.field_11801.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        @NotNull class_6880 primary = null;
        @NotNull class_6880 secondary = null;
        if (data.contains("primary_effect", 8)) {
            primary = data.getCodec("primary_effect", class_7923.field_41174.method_40294()).filter(effects::contains).orElse(null);
        }
        if (data.contains("secondary_effect", 8)) {
            secondary = data.getCodec("secondary_effect", class_7923.field_41174.method_40294()).filter(effects::contains).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<class_4482.class_9309>, class_2338> getBeesData(@Nonnull CompoundData data) {
        List bees = new ArrayList();
        class_2338 flower = class_2338.field_10980;
        if (data.contains("bees", 9)) {
            bees = data.getCodec("bees", class_4482.class_9309.field_49412).orElse(List.of());
        }
        if (data.containsLenient("flower_pos")) {
            flower = DataTypeUtils.getPosCodec(data, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, class_8514.class_8515> getSkulkSensorVibrations(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_8514.class_8515 listener = null;
        int lastFreq = -1;
        if (data.contains("last_vibration_frequency", 3)) {
            lastFreq = data.getInt("last_vibration_frequency");
        }
        if (data.contains("listener", 10)) {
            listener = data.getCodec("listener", class_8514.class_8515.field_44640, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElseGet(class_8514.class_8515::new);
        }
        return Pair.of((Object)lastFreq, listener);
    }

    public static Pair<Long, class_2338> getExitPortal(@Nonnull CompoundData data) {
        long age = -1L;
        class_2338 pos = class_2338.field_10980;
        if (data.contains("Age", 4)) {
            age = data.getLong("Age");
        }
        if (data.containsLenient("exit_portal")) {
            pos = DataTypeUtils.getPosCodec(data, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<class_8242, class_8242>, Boolean> getSignText(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        CompoundData comp;
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (data.contains("front_text", 10)) {
            comp = data.getCompound("front_text");
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(comp)).resultOrPartial().ifPresent(front::set);
        }
        if (data.contains("back_text", 10)) {
            comp = data.getCompound("back_text");
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(comp)).resultOrPartial().ifPresent(back::set);
        }
        if (data.contains("is_waxed", 1)) {
            waxed = data.getBoolean("is_waxed");
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<class_1799, Integer> getBook(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_1799 book = class_1799.field_8037;
        int current = -1;
        if (data.contains("Book", 10)) {
            book = data.getCodec("Book", class_1799.field_24671, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElse(class_1799.field_8037);
        }
        if (data.contains("Page", 3)) {
            current = data.getInt("Page");
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<class_9296, Pair<class_2960, class_2561>> getSkullData(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_9296 profile = null;
        class_2960 note = null;
        class_2561 name = null;
        if (data.contains("note_block_sound", 8)) {
            note = data.getCodec("note_block_sound", class_2960.field_25139).orElse(null);
        }
        if (data.contains("custom_name", 10)) {
            name = DataBlockUtils.getCustomName(data, registry, "custom_name");
        }
        if (data.contains("profile", 10)) {
            profile = data.getCodec("profile", class_9296.field_49359).orElse(null);
        }
        return Pair.of(profile, (Object)Pair.of((Object)note, (Object)name));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Reference2IntOpenHashMap<class_5321<@NotNull class_1860<?>>> getRecipesUsed(@Nonnull CompoundData data) {
        @NotNull UnboundedMapCodec CODEC = Codec.unboundedMap((Codec)class_1860.field_56667, (Codec)Codec.INT);
        @NotNull Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (data.containsLenient("RecipesUsed")) {
            list.putAll(data.getCodec("RecipesUsed", CODEC).orElse(Map.of()));
        }
        return list;
    }

    public static int getOutputSignal(@Nonnull CompoundData data) {
        if (data.contains("OutputSignal", 3)) {
            return data.getInt("OutputSignal");
        }
        return 0;
    }

    public static Optional<class_8966.class_11350> getTrialSpawnerData(@Nonnull CompoundData data) {
        return DataTypeUtils.readFlatMap(data, class_8966.class_11350.field_60376);
    }
}

