/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.util.MathUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class Color4f {
    public static final Codec<Color4f> RGBA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.FLOAT.fieldOf("red").forGetter(get -> Float.valueOf(get.r)), (App)PrimitiveCodec.FLOAT.fieldOf("green").forGetter(get -> Float.valueOf(get.g)), (App)PrimitiveCodec.FLOAT.fieldOf("blue").forGetter(get -> Float.valueOf(get.b)), (App)PrimitiveCodec.FLOAT.fieldOf("alpha").forGetter(get -> Float.valueOf(get.a))).apply((Applicative)instance, Color4f::new));
    public static final Codec<Color4f> RGB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.FLOAT.fieldOf("red").forGetter(get -> Float.valueOf(get.r)), (App)PrimitiveCodec.FLOAT.fieldOf("green").forGetter(get -> Float.valueOf(get.g)), (App)PrimitiveCodec.FLOAT.fieldOf("blue").forGetter(get -> Float.valueOf(get.b))).apply((Applicative)instance, Color4f::new));
    public static final Codec<Color4f> CODEC = RGBA_CODEC;
    public static final Codec<List<Color4f>> LIST_CODEC = CODEC.listOf();
    public static final class_9139<@NotNull ByteBuf, @NotNull Color4f> PACKET_CODEC = new class_9139<ByteBuf, Color4f>(){

        public void encode(ByteBuf buf, Color4f value) {
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.r));
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.g));
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.b));
            class_9135.field_48552.encode((Object)buf, (Object)Float.valueOf(value.a));
        }

        public Color4f decode(ByteBuf buf) {
            return new Color4f(((Float)class_9135.field_48552.decode((Object)buf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)buf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)buf)).floatValue(), ((Float)class_9135.field_48552.decode((Object)buf)).floatValue());
        }
    };
    public static final Pattern HEX_8 = Pattern.compile("(?:0x|#)([a-fA-F0-9]{8})");
    public static final Pattern HEX_6 = Pattern.compile("(?:0x|#)([a-fA-F0-9]{6})");
    public static final Pattern HEX_4 = Pattern.compile("(?:0x|#)([a-fA-F0-9]{4})");
    public static final Pattern HEX_3 = Pattern.compile("(?:0x|#)([a-fA-F0-9]{3})");
    public static final Color4f WHITE = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color4f ZERO = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;
    public final int ri;
    public final int gi;
    public final int bi;
    public final int ai;
    public final int intValue;

    public Color4f(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color4f(float r, float g, float b, float a) {
        if (r == -0.0f) {
            r = 0.0f;
        }
        if (g == -0.0f) {
            g = 0.0f;
        }
        if (b == -0.0f) {
            b = 0.0f;
        }
        if (a == -0.0f) {
            a = 0.0f;
        }
        r = MathUtils.clamp(r, 0.0f, 1.0f);
        g = MathUtils.clamp(g, 0.0f, 1.0f);
        b = MathUtils.clamp(b, 0.0f, 1.0f);
        a = MathUtils.clamp(a, 0.0f, 1.0f);
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.ai = (int)(a * 255.0f);
        this.ri = (int)(r * 255.0f);
        this.gi = (int)(g * 255.0f);
        this.bi = (int)(b * 255.0f);
        this.intValue = this.ai << 24 | this.ri << 16 | this.gi << 8 | this.bi;
    }

    public Color4f withAlpha(float alpha) {
        return Color4f.fromColor(this.intValue, alpha);
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String toString() {
        return Color4f.getHexColorString(this.intValue);
    }

    public String getDebugString() {
        return String.format("Color4f{hex=%s, a = %f, r = %f, g = %f, b = %f, intValue = %d}", Color4f.getHexColorString(this.intValue), Float.valueOf(this.a), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.intValue);
    }

    public String toHexString() {
        return String.format("#%08X", this.intValue);
    }

    public int toVanillaArgb() {
        return class_9848.method_61318((float)this.a, (float)this.r, (float)this.g, (float)this.b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color4f color4f = (Color4f)o;
        return this.intValue == color4f.intValue;
    }

    public int hashCode() {
        return Objects.hash(this.intValue);
    }

    public static Color4f fromColor(int color) {
        float alpha = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        return Color4f.fromColor(color, alpha);
    }

    public static Color4f fromColor(Color4f color) {
        return Color4f.fromColor(color.intValue);
    }

    public static Color4f fromString(String str) {
        return Color4f.fromColor(Color4f.getColorFromString(str, -1));
    }

    public static Color4f fromColor(int color, float alpha) {
        float r = (float)((color & 0xFF0000) >>> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >>> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Color4f(r, g, b, alpha);
    }

    public static Color4f fromColor(Color4f color, float alpha) {
        return Color4f.fromColor(color.intValue, alpha);
    }

    public static String getHexColorString(int color) {
        return String.format("#%08X", color);
    }

    public static int getColorFromString(String colorStr, int defaultColor) {
        Matcher matcher = HEX_8.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = HEX_6.matcher(colorStr)).matches()) {
            try {
                return 0xFF000000 | (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException ignore) {
                return defaultColor;
            }
        }
        matcher = HEX_4.matcher(colorStr);
        if (matcher.matches()) {
            try {
                String str = matcher.group(1);
                int orig = Integer.parseInt(str, 16);
                int a = ((orig & 0xF000) >>> 12) * 17;
                int r = ((orig & 0xF00) >>> 8) * 17;
                int g = ((orig & 0xF0) >>> 4) * 17;
                int b = (orig & 0xF) * 17;
                return a << 24 | r << 16 | g << 8 | b;
            }
            catch (NumberFormatException str) {
                // empty catch block
            }
        }
        if ((matcher = HEX_3.matcher(colorStr)).matches()) {
            try {
                String str = matcher.group(1);
                int orig = Integer.parseInt(str, 16);
                int r = ((orig & 0xF00) >>> 8) * 17;
                int g = ((orig & 0xF0) >>> 4) * 17;
                int b = (orig & 0xF) * 17;
                return 0xFF000000 | r << 16 | g << 8 | b;
            }
            catch (NumberFormatException str) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static int getColorFromHue(int hue) {
        return 0xFF000000 | Color.HSBtoRGB((float)(hue % 360) / 360.0f, 1.0f, 1.0f) & 0xFFFFFF;
    }

    public static float[] convertRgb2Hsv(int color) {
        float[] hsv = new float[3];
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        Color.RGBtoHSB(r, g, b, hsv);
        return hsv;
    }

    public static int toArgbInt(float a, float r, float g, float b) {
        int ai = (int)(a * 255.0f);
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }
}

