/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2495;
import net.minecraft.class_3341;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record IntBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
    public static final Codec<IntBoundingBox> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("minX").forGetter(get -> get.minX), (App)PrimitiveCodec.INT.fieldOf("minY").forGetter(get -> get.minY), (App)PrimitiveCodec.INT.fieldOf("minZ").forGetter(get -> get.minZ), (App)PrimitiveCodec.INT.fieldOf("maxX").forGetter(get -> get.maxX), (App)PrimitiveCodec.INT.fieldOf("maxY").forGetter(get -> get.maxY), (App)PrimitiveCodec.INT.fieldOf("maxZ").forGetter(get -> get.maxZ)).apply((Applicative)inst, IntBoundingBox::new));
    public static final class_9139<@NotNull ByteBuf, @NotNull IntBoundingBox> PACKET_CODEC = new class_9139<ByteBuf, IntBoundingBox>(){

        public void encode(ByteBuf buf, IntBoundingBox value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.minX);
            class_9135.field_49675.encode((Object)buf, (Object)value.minY);
            class_9135.field_49675.encode((Object)buf, (Object)value.minZ);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxX);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxY);
            class_9135.field_49675.encode((Object)buf, (Object)value.maxZ);
        }

        public IntBoundingBox decode(ByteBuf buf) {
            return new IntBoundingBox((Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };

    public boolean containsPos(class_2382 pos) {
        return pos.method_10263() >= this.minX && pos.method_10263() <= this.maxX && pos.method_10260() >= this.minZ && pos.method_10260() <= this.maxZ && pos.method_10264() >= this.minY && pos.method_10264() <= this.maxY;
    }

    public boolean containsPos(long pos) {
        int x = class_2338.method_10061((long)pos);
        int y = class_2338.method_10071((long)pos);
        int z = class_2338.method_10083((long)pos);
        return x >= this.minX && y >= this.minY && z >= this.minZ && x <= this.maxX && y <= this.maxY && z <= this.maxZ;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.maxX >= box.minX && this.minX <= box.maxX && this.maxZ >= box.minZ && this.minZ <= box.maxZ && this.maxY >= box.minY && this.minY <= box.maxY;
    }

    public int getMinValueForAxis(class_2350.class_2351 axis) {
        return switch (axis) {
            case class_2350.class_2351.field_11048 -> this.minX;
            case class_2350.class_2351.field_11052 -> this.minY;
            case class_2350.class_2351.field_11051 -> this.minZ;
            default -> 0;
        };
    }

    public int getMaxValueForAxis(class_2350.class_2351 axis) {
        return switch (axis) {
            case class_2350.class_2351.field_11048 -> this.maxX;
            case class_2350.class_2351.field_11052 -> this.maxY;
            case class_2350.class_2351.field_11051 -> this.maxZ;
            default -> 0;
        };
    }

    public class_3341 toVanillaBox() {
        return new class_3341(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public class_2495 toNBTIntArray() {
        return new class_2495(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }

    public static IntBoundingBox fromVanillaBox(class_3341 box) {
        return IntBoundingBox.createProper(box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420());
    }

    public static IntBoundingBox createProper(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new IntBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static IntBoundingBox createForWorldBounds(@Nullable class_1937 world) {
        int worldMinH = -30000000;
        int worldMaxH = 30000000;
        int worldMinY = world != null ? world.method_31607() : -64;
        int worldMaxY = world != null ? world.method_31600() : 319;
        return new IntBoundingBox(worldMinH, worldMinY, worldMinH, worldMaxH, worldMaxY, worldMaxH);
    }

    public static IntBoundingBox fromArray(int[] coords) {
        if (coords.length == 6) {
            return new IntBoundingBox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }

    public IntBoundingBox expand(int amount) {
        return this.expand(amount, amount, amount);
    }

    public IntBoundingBox expand(int x, int y, int z) {
        return new IntBoundingBox(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public IntBoundingBox shrink(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }
}

