/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;

public record DirectoryCreator(Path dir, @Nullable IDirectoryNavigator navigator, boolean feedback) implements IStringConsumerFeedback
{
    @Override
    public boolean setString(String string) {
        if (string.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", string);
            MaLiLib.LOGGER.warn("DirectoryCreator: Failed to create directory; Directory is invalid/empty.");
            return false;
        }
        Path newDir = this.dir().resolve(string);
        if (Files.exists(newDir, new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_already_exists", newDir.toAbsolutePath());
            MaLiLib.LOGGER.warn("DirectoryCreator: Failed to create directory '{}'; Destination already exists.", (Object)this.dir().toAbsolutePath());
            return false;
        }
        try {
            Files.createDirectory(newDir, new FileAttribute[0]);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", newDir.toAbsolutePath());
            MaLiLib.LOGGER.error("DirectoryCreator: Exception creating directory '{}'; {}", (Object)this.dir().toAbsolutePath(), (Object)err.getLocalizedMessage());
            return false;
        }
        if (this.navigator() != null) {
            this.navigator().switchToDirectory(newDir);
        }
        if (this.feedback()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.directory_created", string);
        }
        MaLiLib.debugLog("DirectoryCreator: Created directory '{}'", newDir.toAbsolutePath());
        return true;
    }
}

