/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.interfaces.ISliderCallback;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.GuiContext;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class WidgetSlider
extends WidgetBase {
    public static final class_2960 BUTTON_TEXTURE = class_2960.method_60656((String)"widget/button");
    public static final class_2960 BUTTON_DISABLE_TEXTURE = class_2960.method_60656((String)"widget/button_disabled");
    protected final ISliderCallback callback;
    protected int sliderWidth;
    protected int lastMouseX;
    protected boolean dragging;

    public WidgetSlider(int x, int y, int width, int height, ISliderCallback callback) {
        super(x, y, width, height);
        this.callback = callback;
        int usableWidth = this.width - 4;
        this.sliderWidth = class_3532.method_15340((int)(usableWidth / callback.getMaxSteps()), (int)8, (int)(usableWidth / 2));
    }

    @Override
    protected boolean onMouseClickedImpl(class_11909 click, boolean doubleClick) {
        this.callback.setValueRelative(this.getRelativePosition((int)click.comp_4798()));
        this.lastMouseX = (int)click.comp_4798();
        this.dragging = true;
        return true;
    }

    @Override
    public void onMouseReleasedImpl(class_11909 click) {
        this.dragging = false;
    }

    @Override
    public void render(GuiContext ctx, int mouseX, int mouseY, boolean selected) {
        super.render(ctx, mouseX, mouseY, selected);
        if (this.dragging && mouseX != this.lastMouseX) {
            this.callback.setValueRelative(this.getRelativePosition(mouseX));
            this.lastMouseX = mouseX;
        }
        ctx.method_52706(class_10799.field_56883, BUTTON_DISABLE_TEXTURE, this.x + 1, this.y, this.width - 3, 20);
        double relPos = this.callback.getValueRelative();
        int sw = this.sliderWidth;
        int usableWidth = this.width - 4 - sw;
        int s = sw / 2;
        ctx.method_52706(class_10799.field_56883, BUTTON_TEXTURE, this.x + 2 + (int)(relPos * (double)usableWidth), this.y, sw, 20);
        String str = this.callback.getFormattedDisplayValue();
        int w = this.getStringWidth(str);
        this.drawString(ctx, this.x + this.width / 2 - w / 2, this.y + 6, -96, str);
    }

    protected double getRelativePosition(int mouseX) {
        int relPos = mouseX - this.x - this.sliderWidth / 2;
        return class_3532.method_15350((double)((double)relPos / (double)(this.width - this.sliderWidth - 4)), (double)0.0, (double)1.0);
    }
}

