/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.litematica.materials.json.MaterialListJsonBase;
import fi.dy.masa.litematica.materials.json.MaterialListJsonEntry;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10298;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MaterialListJsonCache {
    private static final AnsiLogger LOGGER = new AnsiLogger(MaterialListJsonCache.class, true, true);
    private final List<Entry> entries = new ArrayList<Entry>();

    public void putEntry(Entry input) {
        if (!this.entries.isEmpty()) {
            class_6880<class_1792> item = input.rawItem();
            int total = input.total();
            List<Step> steps = input.steps();
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                if (!entry.rawItem().equals(item)) continue;
                List<Step> entrySteps = entry.steps();
                Entry newEntry = new Entry(item, entry.total() + total, this.combineSteps(steps, entrySteps));
                this.entries.set(i, newEntry);
                return;
            }
        }
        this.entries.add(input);
    }

    public List<Step> combineSteps(List<Step> left, List<Step> right) {
        Step entry;
        int i;
        ArrayList<Step> list = new ArrayList<Step>();
        ArrayList<Integer> ignores = new ArrayList<Integer>();
        LOGGER.info("combineSteps: left [{}], right [{}]", new Object[]{left.size(), right.size()});
        if (left.isEmpty() && !right.isEmpty()) {
            return right;
        }
        for (i = 0; i < left.size(); ++i) {
            entry = left.get(i);
            class_6880<class_1792> item = entry.stepItem();
            int count = entry.count();
            boolean matched = false;
            for (int j = 0; j < right.size(); ++j) {
                Step otherEntry = right.get(j);
                if (!item.equals(otherEntry.stepItem())) continue;
                Step newEntry = new Step(item, count + otherEntry.count(), entry.type(), entry.category(), entry.networkId());
                newEntry.debug();
                ignores.add(j);
                list.add(newEntry);
                matched = true;
            }
            if (matched) continue;
            list.add(entry);
        }
        for (i = 0; i < right.size(); ++i) {
            entry = right.get(i);
            LOGGER.info("ignores: // right[{}]: [{}] (Contains: {})", new Object[]{i, entry.stepItem().method_55840(), ignores.contains(i)});
            if (ignores.contains(i)) continue;
            list.add(entry);
        }
        LOGGER.info("combineSteps: combined [{}]", new Object[]{list.size()});
        return list;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Iterable<Entry> iterator() {
        return Iterables.concat((Iterable[])new Iterable[]{this.entries});
    }

    public Stream<Entry> stream() {
        return this.entries.stream();
    }

    public void clear() {
        this.entries.clear();
    }

    public Pair<Step, List<Step>> buildStepsBase(MaterialListJsonBase base, List<Step> lastSteps) {
        Pair<Step, List<MaterialListJsonBase>> pair;
        class_6880<class_1792> resultItem = base.getInput();
        int total = base.getCount();
        ArrayList requirements = new ArrayList();
        Step finalStep = null;
        LOGGER.debug("buildStepsBase: resultItem: [{}], count [{}], lastSteps [{}]", new Object[]{resultItem.method_55840(), total, lastSteps.size()});
        if (base.getMaterialsFurnace() != null) {
            pair = this.buildStepsEntryEach(resultItem, base.getMaterialsFurnace(), RecipeBookUtils.Type.FURNACE);
            if (!((List)pair.getRight()).isEmpty()) {
                requirements.addAll((Collection)pair.getRight());
            }
            Step furnaceStep = (Step)pair.getLeft();
            lastSteps.addFirst(furnaceStep);
        }
        if (base.getMaterialsStonecutter() != null) {
            pair = this.buildStepsEntryEach(resultItem, base.getMaterialsStonecutter(), RecipeBookUtils.Type.STONECUTTER);
            if (!((List)pair.getRight()).isEmpty()) {
                requirements.addAll((Collection)pair.getRight());
            }
            Step stonecutterStep = (Step)pair.getLeft();
            lastSteps.addFirst(stonecutterStep);
        }
        if (base.getMaterialsCrafting() != null) {
            pair = this.buildStepsEntryEach(resultItem, base.getMaterialsCrafting(), RecipeBookUtils.Type.SHAPELESS);
            if (!((List)pair.getRight()).isEmpty()) {
                requirements.addAll((Collection)pair.getRight());
            }
            Step recipeStep = (Step)pair.getLeft();
            lastSteps.addFirst(recipeStep);
        }
        if (base.getMaterialsRemaining() != null) {
            pair = this.buildStepsEntryEach(resultItem, base.getMaterialsRemaining(), RecipeBookUtils.Type.UNKNOWN);
            if (!((List)pair.getRight()).isEmpty()) {
                requirements.addAll((Collection)pair.getRight());
            }
            finalStep = (Step)pair.getLeft();
            lastSteps.addFirst(finalStep);
        }
        if (!requirements.isEmpty()) {
            List<Step> list = new ArrayList<Step>();
            for (MaterialListJsonBase baseEach : requirements) {
                Pair<Step, List<Step>> pair2 = this.buildStepsBaseEach(baseEach, lastSteps);
                if (pair2.getRight() != null && !((List)pair2.getRight()).isEmpty()) {
                    list = this.combineSteps(list, (List)pair2.getRight());
                }
                if (pair2.getLeft() == null) continue;
                list.add((Step)pair2.getLeft());
                lastSteps = this.combineSteps(list, lastSteps);
                Entry entryOut = new Entry(resultItem, total, lastSteps);
                LOGGER.debug("buildStepsBase: Entry (Requirements) -->", new Object[0]);
                entryOut.debug();
                this.putEntry(entryOut);
                return Pair.of(null, List.of());
            }
        } else if (finalStep != null) {
            Entry entryOut = new Entry(resultItem, total, lastSteps);
            LOGGER.debug("buildStepsBase: Entry (No-Requirements) -->", new Object[0]);
            entryOut.debug();
            this.putEntry(entryOut);
            return Pair.of(null, List.of());
        }
        return Pair.of(finalStep, lastSteps);
    }

    public Pair<Step, List<Step>> buildStepsBaseEach(MaterialListJsonBase base, List<Step> lastSteps) {
        return this.buildStepsBase(base, lastSteps);
    }

    public Pair<Step, List<MaterialListJsonBase>> buildStepsEntryEach(class_6880<class_1792> resultItem, MaterialListJsonEntry materials, RecipeBookUtils.Type typeIn) {
        class_6880<class_1792> stepItem = materials.getInputItem();
        int stepCount = materials.getTotal();
        LOGGER.debug("buildStepsEntryEach: resultItem: [{}], typeIn [{}]", new Object[]{resultItem.method_55840(), typeIn.name()});
        if (materials.hasOutput()) {
            class_10298 stepNetworkId = materials.getPrimaryId();
            HashMap<class_10298, class_10355> stepCats = materials.getRecipeCategory();
            HashMap<class_10298, RecipeBookUtils.Type> stepTypes = materials.getRecipeTypes();
            class_10355 category = stepCats.get(stepNetworkId);
            RecipeBookUtils.Type type = stepTypes.get(stepNetworkId);
            Step stepOut = new Step(stepItem, stepCount, type, RecipeBookUtils.getRecipeCategoryId((class_10355)category), stepNetworkId.comp_3267());
            LOGGER.debug("buildStepsEntryEach: (Output) from resultItem [{}]", new Object[]{resultItem.method_55840()});
            stepOut.debug();
            return Pair.of((Object)stepOut, materials.getRequirements());
        }
        Step stepOut = new Step(stepItem, stepCount, typeIn, "GATHER", -1);
        LOGGER.debug("buildStepsEntryEach: (Basic) from resultItem [{}]", new Object[]{resultItem.method_55840()});
        stepOut.debug();
        return Pair.of((Object)stepOut, List.of());
    }

    public JsonElement toJson(class_6903<?> ops) {
        JsonArray arr = new JsonArray();
        if (!this.isEmpty()) {
            this.entries.forEach(entry -> arr.add((JsonElement)Entry.CODEC.encodeStart((DynamicOps)ops, entry).getPartialOrThrow()));
        }
        return arr;
    }

    public record Entry(class_6880<class_1792> rawItem, Integer total, List<Step> steps) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1792.field_54952.fieldOf("RawItem").forGetter(get -> get.rawItem), (App)PrimitiveCodec.INT.fieldOf("Total").forGetter(get -> get.total), (App)Codec.list(Step.CODEC).fieldOf("Steps").forGetter(get -> get.steps)).apply((Applicative)inst, Entry::new));

        public void debug() {
            LOGGER.debug("Entry(): item: [{}], total: [{}], STEPS -->", new Object[]{this.rawItem().method_55840(), this.total()});
            for (Step step : this.steps()) {
                step.debug();
            }
        }
    }

    public record Step(class_6880<class_1792> stepItem, Integer count, RecipeBookUtils.Type type, String category, Integer networkId) {
        public static final Codec<Step> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1792.field_54952.fieldOf("StepItem").forGetter(get -> get.stepItem), (App)PrimitiveCodec.INT.fieldOf("Count").forGetter(get -> get.count), (App)RecipeBookUtils.Type.CODEC.fieldOf("RecipeType").forGetter(get -> get.type), (App)PrimitiveCodec.STRING.fieldOf("RecipeCategory").forGetter(get -> get.category), (App)PrimitiveCodec.INT.fieldOf("RecipeId").forGetter(get -> get.networkId)).apply((Applicative)inst, Step::new));

        public void debug() {
            LOGGER.debug("Step(): item: [{}], count: [{}], type: [{}], category: [{}], id: [{}]", new Object[]{this.stepItem().method_55840(), this.count(), this.type().name(), this.category(), this.networkId()});
        }
    }
}

