/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.materials.json.MaterialListJsonEntry;
import fi.dy.masa.malilib.mixin.recipe.IMixinIngredient;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10298;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MaterialListJsonBase {
    private final class_6880<class_1792> input;
    private final int count;
    @Nullable
    private MaterialListJsonEntry materialsCrafting;
    @Nullable
    private MaterialListJsonEntry materialsStonecutter;
    @Nullable
    private MaterialListJsonEntry materialsFurnace;
    @Nullable
    private MaterialListJsonEntry materialsRemaining;

    public MaterialListJsonBase(class_6880<class_1792> input, int count, @Nullable class_6880<class_1792> prevItem) {
        MaterialListJsonEntry entryRemaining;
        MaterialListJsonEntry entryFurnace;
        MaterialListJsonEntry entryCrafting;
        this.input = input;
        this.count = count;
        boolean matched = false;
        MaterialListJsonEntry entryStonecutter = MaterialListJsonEntry.build(input, count, List.of(RecipeBookUtils.Type.STONECUTTER), prevItem);
        if (entryStonecutter != null && entryStonecutter.hasOutput()) {
            if (this.checkIfLoop(entryStonecutter, input, prevItem)) {
                this.materialsRemaining = MaterialListJsonEntry.build(input, count, List.of(), prevItem);
                return;
            }
            this.materialsStonecutter = entryStonecutter;
            matched = true;
        }
        if ((entryCrafting = MaterialListJsonEntry.build(input, count, List.of(RecipeBookUtils.Type.SHAPED, RecipeBookUtils.Type.SHAPELESS), prevItem)) != null && entryCrafting.hasOutput()) {
            if (this.checkIfLoop(entryCrafting, input, prevItem)) {
                this.materialsRemaining = MaterialListJsonEntry.build(input, count, List.of(), prevItem);
                return;
            }
            this.materialsCrafting = entryCrafting;
            matched = true;
        }
        if (!matched && (entryFurnace = MaterialListJsonEntry.build(input, count, List.of(RecipeBookUtils.Type.FURNACE), prevItem)) != null && entryFurnace.hasOutput()) {
            if (this.checkIfLoop(entryFurnace, input, prevItem)) {
                this.materialsRemaining = MaterialListJsonEntry.build(input, count, List.of(), prevItem);
                return;
            }
            this.materialsFurnace = entryFurnace;
            matched = true;
        }
        if (!matched && (entryRemaining = MaterialListJsonEntry.build(input, count, List.of(), prevItem)) != null) {
            this.materialsRemaining = entryRemaining;
        }
    }

    @Nullable
    public MaterialListJsonEntry getMaterialsCrafting() {
        return this.materialsCrafting;
    }

    @Nullable
    public MaterialListJsonEntry getMaterialsStonecutter() {
        return this.materialsStonecutter;
    }

    @Nullable
    public MaterialListJsonEntry getMaterialsFurnace() {
        return this.materialsFurnace;
    }

    @Nullable
    public MaterialListJsonEntry getMaterialsRemaining() {
        return this.materialsRemaining;
    }

    public class_6880<class_1792> getInput() {
        return this.input;
    }

    public int getCount() {
        return this.count;
    }

    private boolean checkIfLoop(MaterialListJsonEntry entry, class_6880<class_1792> inputItem, class_6880<class_1792> prevItem) {
        class_10298 firstId;
        List<class_1856> ingredients;
        class_1856 ingredient;
        List ingItems;
        HashMap<class_10298, List<class_1856>> recipeReq = entry.getRecipeRequirements();
        HashMap<class_10298, RecipeBookUtils.Type> recipeTypes = entry.getRecipeTypes();
        Litematica.LOGGER.warn("checkIfLoop(): input: [{}], prev: [{}]", (Object)inputItem.method_55840(), (Object)(prevItem != null ? prevItem.method_55840() : "<>"));
        if (!recipeReq.isEmpty() && !recipeTypes.isEmpty() && ((ingItems = ((IMixinIngredient)(ingredient = (ingredients = recipeReq.get(firstId = (class_10298)recipeTypes.keySet().stream().toList().getFirst())).getFirst())).malilib_getEntries().method_40239().toList()).contains(inputItem) || ingItems.contains(prevItem))) {
            return true;
        }
        List<MaterialListJsonBase> list = entry.getRequirements();
        for (MaterialListJsonBase eachItem : list) {
            if (eachItem.getInput() == inputItem) {
                return true;
            }
            if (eachItem.getInput() != prevItem) continue;
            return true;
        }
        return inputItem == prevItem;
    }

    public JsonElement toJson(class_6903<?> ops) {
        JsonObject obj = new JsonObject();
        obj.add("Item", (JsonElement)new JsonPrimitive(this.getInput().method_55840()));
        obj.add("Count", (JsonElement)new JsonPrimitive((Number)this.getCount()));
        if (this.materialsCrafting != null) {
            obj.add("CraftingMaterials", this.materialsCrafting.toJson(ops));
        }
        if (this.materialsStonecutter != null) {
            obj.add("StonecutterMaterials", this.materialsStonecutter.toJson(ops));
        }
        if (this.materialsFurnace != null) {
            obj.add("FurnaceMaterials", this.materialsFurnace.toJson(ops));
        }
        if (this.materialsRemaining != null) {
            obj.add("RemainingMaterials", this.materialsRemaining.toJson(ops));
        }
        return obj;
    }
}

