/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.json.MaterialListJsonBase;
import fi.dy.masa.litematica.materials.json.MaterialListJsonCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MaterialListJson {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<MaterialListJsonBase> data = new ArrayList<MaterialListJsonBase>();

    public List<MaterialListJsonBase> getMaterials() {
        return this.data;
    }

    public boolean readMaterialListAll(MaterialListBase materialList, MaterialListJsonCache cache) {
        ImmutableList<MaterialListEntry> materials = materialList.getMaterialsAll();
        if (materials.isEmpty()) {
            return false;
        }
        this.data.clear();
        materials.forEach(entry -> {
            MaterialListJsonBase base = new MaterialListJsonBase((class_6880<class_1792>)entry.getStack().method_41409(), entry.getStack().method_7947() * entry.getCountTotal(), null);
            this.data.add(base);
            cache.buildStepsBase(base, new ArrayList<MaterialListJsonCache.Step>());
        });
        return true;
    }

    public boolean readMaterialListMissingOnly(MaterialListBase materialList, MaterialListJsonCache cache) {
        List<MaterialListEntry> materials = materialList.getMaterialsMissingOnly(false);
        if (materials.isEmpty()) {
            return false;
        }
        this.data.clear();
        materials.forEach(entry -> {
            MaterialListJsonBase base = new MaterialListJsonBase((class_6880<class_1792>)entry.getStack().method_41409(), entry.getStack().method_7947() * entry.getCountTotal(), null);
            this.data.add(base);
            cache.buildStepsBase(base, new ArrayList<MaterialListJsonCache.Step>());
        });
        return true;
    }

    public boolean writeJson(Path file, class_310 mc) {
        if (this.data.isEmpty() || mc.field_1687 == null) {
            return false;
        }
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException err) {
                Litematica.LOGGER.error("MaterialListJson#toJson(): Exception deleting file '{}'; {}", (Object)file.toAbsolutePath().toString(), (Object)err.getLocalizedMessage());
                return false;
            }
        }
        try {
            Files.writeString(file, (CharSequence)this.GSON.toJson(this.toJson(mc.field_1687.method_30349())), new OpenOption[0]);
            Litematica.LOGGER.info("MaterialListJson#toJson(): Exported Materials file '{}' successfully.", (Object)file.toAbsolutePath().toString());
            return true;
        }
        catch (IOException err) {
            Litematica.LOGGER.error("MaterialListJson#toJson(): Exception writing file '{}'; {}", (Object)file.toAbsolutePath().toString(), (Object)err.getLocalizedMessage());
            return false;
        }
    }

    public boolean writeCacheJson(MaterialListJsonCache cache, Path file, class_310 mc) {
        if (cache.isEmpty() || mc.field_1687 == null) {
            return false;
        }
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException err) {
                Litematica.LOGGER.error("MaterialListJson#writeCacheJson(): Exception deleting file '{}'; {}", (Object)file.toAbsolutePath().toString(), (Object)err.getLocalizedMessage());
                return false;
            }
        }
        try {
            Files.writeString(file, (CharSequence)this.GSON.toJson(cache.toJson(mc.field_1687.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE))), new OpenOption[0]);
            Litematica.LOGGER.info("MaterialListJson#writeCacheJson(): Exported Materials Cache file '{}' successfully.", (Object)file.toAbsolutePath().toString());
            return true;
        }
        catch (IOException err) {
            Litematica.LOGGER.error("MaterialListJson#writeCacheJson(): Exception writing file '{}'; {}", (Object)file.toAbsolutePath().toString(), (Object)err.getLocalizedMessage());
            return false;
        }
    }

    public JsonElement toJson(class_5455 registry) {
        class_6903 ops = registry.method_57093((DynamicOps)JsonOps.INSTANCE);
        JsonArray arr = new JsonArray();
        this.data.forEach(entry -> arr.add(entry.toJson(ops)));
        return arr;
    }

    public void clear() {
        this.data.clear();
    }
}

